---
myst:
  html_meta:
      keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
                définitions des colonnes, spécifications des colonnes, 
                tableaux en LaTeX, problème avec un tableau
---

# Que signifie l'erreur : "Illegal character in array arg" ?

- **Message** : `Illegal character in array arg`
- **Origine** : LaTeX

Cette erreur s'obtient lorsque la spécification de colonne 
dans les environnements `tabular` ou `array`, ou dans une commande 
`\multicolumn`, contient des caractères non définis comme spécificateurs
de colonne.

Une cause fréquente est d'utiliser la syntaxe étendue 
de l'extension <ctanpkg:array>, en ayant oublié de la charger dans le préambule
(par exemple, en ayant copié un tableau à partir d'un autre document). 
La question 
"[](/3_composition/tableaux/colonnes/changer_la_fonte_d_une_colonne)" donne 
un exemple dans lequel vous retrouverez ce message d'erreur si vous retirez 
l'appel de l'extension <ctanpkg:array>.


:::{sources}
- [FAQ erreurs - Lettre I](https://latex.developpez.com/faq/erreurs?page=I), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::