// Copyright 2014 The PDFium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#ifndef XFA_FWL_FWL_WIDGETDEF_H_
#define XFA_FWL_FWL_WIDGETDEF_H_

#include <stdint.h>

namespace pdfium {

// Same as enum FWL_VKEYCODE in public/fpdf_fwlevent.h, but duplicated here
// to keep xfa/fwl standalone.
enum XFA_FWL_VKEYCODE {
  XFA_FWL_VKEY_Back = 0x08,
  XFA_FWL_VKEY_Tab = 0x09,
  XFA_FWL_VKEY_NewLine = 0x0A,
  XFA_FWL_VKEY_Clear = 0x0C,
  XFA_FWL_VKEY_Return = 0x0D,
  XFA_FWL_VKEY_Shift = 0x10,
  XFA_FWL_VKEY_Control = 0x11,
  XFA_FWL_VKEY_Menu = 0x12,
  XFA_FWL_VKEY_Pause = 0x13,
  XFA_FWL_VKEY_Capital = 0x14,
  XFA_FWL_VKEY_Kana = 0x15,
  XFA_FWL_VKEY_Hangul = 0x15,
  XFA_FWL_VKEY_Junja = 0x17,
  XFA_FWL_VKEY_Final = 0x18,
  XFA_FWL_VKEY_Hanja = 0x19,
  XFA_FWL_VKEY_Kanji = 0x19,
  XFA_FWL_VKEY_Escape = 0x1B,
  XFA_FWL_VKEY_Convert = 0x1C,
  XFA_FWL_VKEY_NonConvert = 0x1D,
  XFA_FWL_VKEY_Accept = 0x1E,
  XFA_FWL_VKEY_ModeChange = 0x1F,
  XFA_FWL_VKEY_Space = 0x20,
  XFA_FWL_VKEY_Prior = 0x21,
  XFA_FWL_VKEY_Next = 0x22,
  XFA_FWL_VKEY_End = 0x23,
  XFA_FWL_VKEY_Home = 0x24,
  XFA_FWL_VKEY_Left = 0x25,
  XFA_FWL_VKEY_Up = 0x26,
  XFA_FWL_VKEY_Right = 0x27,
  XFA_FWL_VKEY_Down = 0x28,
  XFA_FWL_VKEY_Select = 0x29,
  XFA_FWL_VKEY_Print = 0x2A,
  XFA_FWL_VKEY_Execute = 0x2B,
  XFA_FWL_VKEY_Snapshot = 0x2C,
  XFA_FWL_VKEY_Insert = 0x2D,
  XFA_FWL_VKEY_Delete = 0x2E,
  XFA_FWL_VKEY_Help = 0x2F,
  XFA_FWL_VKEY_0 = 0x30,
  XFA_FWL_VKEY_1 = 0x31,
  XFA_FWL_VKEY_2 = 0x32,
  XFA_FWL_VKEY_3 = 0x33,
  XFA_FWL_VKEY_4 = 0x34,
  XFA_FWL_VKEY_5 = 0x35,
  XFA_FWL_VKEY_6 = 0x36,
  XFA_FWL_VKEY_7 = 0x37,
  XFA_FWL_VKEY_8 = 0x38,
  XFA_FWL_VKEY_9 = 0x39,
  XFA_FWL_VKEY_A = 0x41,
  XFA_FWL_VKEY_B = 0x42,
  XFA_FWL_VKEY_C = 0x43,
  XFA_FWL_VKEY_D = 0x44,
  XFA_FWL_VKEY_E = 0x45,
  XFA_FWL_VKEY_F = 0x46,
  XFA_FWL_VKEY_G = 0x47,
  XFA_FWL_VKEY_H = 0x48,
  XFA_FWL_VKEY_I = 0x49,
  XFA_FWL_VKEY_J = 0x4A,
  XFA_FWL_VKEY_K = 0x4B,
  XFA_FWL_VKEY_L = 0x4C,
  XFA_FWL_VKEY_M = 0x4D,
  XFA_FWL_VKEY_N = 0x4E,
  XFA_FWL_VKEY_O = 0x4F,
  XFA_FWL_VKEY_P = 0x50,
  XFA_FWL_VKEY_Q = 0x51,
  XFA_FWL_VKEY_R = 0x52,
  XFA_FWL_VKEY_S = 0x53,
  XFA_FWL_VKEY_T = 0x54,
  XFA_FWL_VKEY_U = 0x55,
  XFA_FWL_VKEY_V = 0x56,
  XFA_FWL_VKEY_W = 0x57,
  XFA_FWL_VKEY_X = 0x58,
  XFA_FWL_VKEY_Y = 0x59,
  XFA_FWL_VKEY_Z = 0x5A,
  XFA_FWL_VKEY_LWin = 0x5B,
  XFA_FWL_VKEY_Command = 0x5B,
  XFA_FWL_VKEY_RWin = 0x5C,
  XFA_FWL_VKEY_Apps = 0x5D,
  XFA_FWL_VKEY_Sleep = 0x5F,
  XFA_FWL_VKEY_NumPad0 = 0x60,
  XFA_FWL_VKEY_NumPad1 = 0x61,
  XFA_FWL_VKEY_NumPad2 = 0x62,
  XFA_FWL_VKEY_NumPad3 = 0x63,
  XFA_FWL_VKEY_NumPad4 = 0x64,
  XFA_FWL_VKEY_NumPad5 = 0x65,
  XFA_FWL_VKEY_NumPad6 = 0x66,
  XFA_FWL_VKEY_NumPad7 = 0x67,
  XFA_FWL_VKEY_NumPad8 = 0x68,
  XFA_FWL_VKEY_NumPad9 = 0x69,
  XFA_FWL_VKEY_Multiply = 0x6A,
  XFA_FWL_VKEY_Add = 0x6B,
  XFA_FWL_VKEY_Separator = 0x6C,
  XFA_FWL_VKEY_Subtract = 0x6D,
  XFA_FWL_VKEY_Decimal = 0x6E,
  XFA_FWL_VKEY_Divide = 0x6F,
  XFA_FWL_VKEY_F1 = 0x70,
  XFA_FWL_VKEY_F2 = 0x71,
  XFA_FWL_VKEY_F3 = 0x72,
  XFA_FWL_VKEY_F4 = 0x73,
  XFA_FWL_VKEY_F5 = 0x74,
  XFA_FWL_VKEY_F6 = 0x75,
  XFA_FWL_VKEY_F7 = 0x76,
  XFA_FWL_VKEY_F8 = 0x77,
  XFA_FWL_VKEY_F9 = 0x78,
  XFA_FWL_VKEY_F10 = 0x79,
  XFA_FWL_VKEY_F11 = 0x7A,
  XFA_FWL_VKEY_F12 = 0x7B,
  XFA_FWL_VKEY_F13 = 0x7C,
  XFA_FWL_VKEY_F14 = 0x7D,
  XFA_FWL_VKEY_F15 = 0x7E,
  XFA_FWL_VKEY_F16 = 0x7F,
  XFA_FWL_VKEY_F17 = 0x80,
  XFA_FWL_VKEY_F18 = 0x81,
  XFA_FWL_VKEY_F19 = 0x82,
  XFA_FWL_VKEY_F20 = 0x83,
  XFA_FWL_VKEY_F21 = 0x84,
  XFA_FWL_VKEY_F22 = 0x85,
  XFA_FWL_VKEY_F23 = 0x86,
  XFA_FWL_VKEY_F24 = 0x87,
  XFA_FWL_VKEY_NunLock = 0x90,
  XFA_FWL_VKEY_Scroll = 0x91,
  XFA_FWL_VKEY_LShift = 0xA0,
  XFA_FWL_VKEY_RShift = 0xA1,
  XFA_FWL_VKEY_LControl = 0xA2,
  XFA_FWL_VKEY_RControl = 0xA3,
  XFA_FWL_VKEY_LMenu = 0xA4,
  XFA_FWL_VKEY_RMenu = 0xA5,
  XFA_FWL_VKEY_BROWSER_Back = 0xA6,
  XFA_FWL_VKEY_BROWSER_Forward = 0xA7,
  XFA_FWL_VKEY_BROWSER_Refresh = 0xA8,
  XFA_FWL_VKEY_BROWSER_Stop = 0xA9,
  XFA_FWL_VKEY_BROWSER_Search = 0xAA,
  XFA_FWL_VKEY_BROWSER_Favorites = 0xAB,
  XFA_FWL_VKEY_BROWSER_Home = 0xAC,
  XFA_FWL_VKEY_VOLUME_Mute = 0xAD,
  XFA_FWL_VKEY_VOLUME_Down = 0xAE,
  XFA_FWL_VKEY_VOLUME_Up = 0xAF,
  XFA_FWL_VKEY_MEDIA_NEXT_Track = 0xB0,
  XFA_FWL_VKEY_MEDIA_PREV_Track = 0xB1,
  XFA_FWL_VKEY_MEDIA_Stop = 0xB2,
  XFA_FWL_VKEY_MEDIA_PLAY_Pause = 0xB3,
  XFA_FWL_VKEY_MEDIA_LAUNCH_Mail = 0xB4,
  XFA_FWL_VKEY_MEDIA_LAUNCH_MEDIA_Select = 0xB5,
  XFA_FWL_VKEY_MEDIA_LAUNCH_APP1 = 0xB6,
  XFA_FWL_VKEY_MEDIA_LAUNCH_APP2 = 0xB7,
  XFA_FWL_VKEY_OEM_1 = 0xBA,
  XFA_FWL_VKEY_OEM_Plus = 0xBB,
  XFA_FWL_VKEY_OEM_Comma = 0xBC,
  XFA_FWL_VKEY_OEM_Minus = 0xBD,
  XFA_FWL_VKEY_OEM_Period = 0xBE,
  XFA_FWL_VKEY_OEM_2 = 0xBF,
  XFA_FWL_VKEY_OEM_3 = 0xC0,
  XFA_FWL_VKEY_OEM_4 = 0xDB,
  XFA_FWL_VKEY_OEM_5 = 0xDC,
  XFA_FWL_VKEY_OEM_6 = 0xDD,
  XFA_FWL_VKEY_OEM_7 = 0xDE,
  XFA_FWL_VKEY_OEM_8 = 0xDF,
  XFA_FWL_VKEY_OEM_102 = 0xE2,
  XFA_FWL_VKEY_ProcessKey = 0xE5,
  XFA_FWL_VKEY_Packet = 0xE7,
  XFA_FWL_VKEY_Attn = 0xF6,
  XFA_FWL_VKEY_Crsel = 0xF7,
  XFA_FWL_VKEY_Exsel = 0xF8,
  XFA_FWL_VKEY_Ereof = 0xF9,
  XFA_FWL_VKEY_Play = 0xFA,
  XFA_FWL_VKEY_Zoom = 0xFB,
  XFA_FWL_VKEY_NoName = 0xFC,
  XFA_FWL_VKEY_PA1 = 0xFD,
  XFA_FWL_VKEY_OEM_Clear = 0xFE,
  XFA_FWL_VKEY_Unknown = 0,
};

// Derived from FWL_EVENTFLAG in public/fwl_event.h, but not the same
// values bit-for-bit, duplicated here to keep XFA standalone.
enum class XFA_FWL_KeyFlag : uint8_t {
  kCtrl = 1 << 0,
  kAlt = 1 << 1,
  kShift = 1 << 2,
  kCommand = 1 << 3,
  kLButton = 1 << 4,
  kRButton = 1 << 5,
  kMButton = 1 << 6
};

}  // namespace pdfium

// TODO(crbug.com/42271761): Remove.
using pdfium::XFA_FWL_KeyFlag;
using pdfium::XFA_FWL_VKEYCODE;

#endif  // XFA_FWL_FWL_WIDGETDEF_H_
